/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

#define SHOW_GRID

float pi  = atan(1.0)*4.0;
float tau = atan(1.0)*8.0;

float scale = 1.0 / 6.0;

vec2 digitSize    = vec2(1.0,1.5) * scale;
vec2 digitSpacing = vec2(1.1,1.6) * scale;

// Distance to a line segment.

float dfLine ( vec2 uv, vec2 start, vec2 end )
 {
   start *= scale;
   end   *= scale;

   vec2  line = end - start;
   float frac = dot(uv-start,line) / dot(line,line);

   return distance( start + line * clamp(frac,0.0,1.0), uv );

 }

// Distance to the edge of a circle.

float dfCirc ( vec2 uv, vec2 origin, float radius )
 {
   origin *= scale;
   radius *= scale;

   return abs ( length(uv-origin) - radius );

 }

// Distance to an arc.  Due to a problem when using the Intel
// Integrated Graphics Processor in my laptop I had to change
// this function. I did eventualy find  the root cause of the
// problem and a trivial fix for it but by then I had already
// modified the function significantly and it no longer looks
// much like the original. TheEmu.

float dfArc ( vec2 uv, vec2 origin, float start, float sweep, float radius )
 {

   // Shift origin to the center of the arc.

   uv = uv - origin*scale;

   // Get angle measured from start of arc.

   float ang = mod ( atan(uv.y,uv.x) + tau - start, tau );

   // If outside of arc use its nearest end.

   if ( ang > sweep )
    { ang = ( ang > (tau+sweep)*0.5 ) ? 0.0 : sweep;
    }

   // Actual angle and its cos and sine.

   ang = ang + start;
   vec2 cs = vec2 ( cos(ang), sin(ang) );

   // Distance to nearest point on the arc.

   return distance ( cs*radius*scale, uv );

 }

// Distance to the digit "d" (0-9).

float dfDigit (  vec2 uv, vec2 origin, float d )
 {
   uv = uv - origin;

   float dist = 1.0e6;

   // Original series of ifs replaced by a switch construct. TheEmu.

   switch ( int(d) )
    { case 0 :
         dist = min ( dist, dfLine ( uv, vec2(1.000,1.000), vec2(1.000,0.500) ) );
         dist = min ( dist, dfLine ( uv, vec2(0.000,1.000), vec2(0.000,0.500) ) );
         dist = min ( dist, dfArc  ( uv, vec2(0.500,1.000), 0.0, pi, 0.5 ) );
         dist = min ( dist, dfArc  ( uv, vec2(0.500,0.500), pi,  pi, 0.5 ) );
         break;
      case 1 :
         dist = min ( dist, dfLine ( uv, vec2(0.500,1.500), vec2(0.500,0.000) ) );
         break;
      case 2 :
         dist = min ( dist, dfLine ( uv, vec2(1.000,0.000), vec2(0.000,0.000) ) );
         dist = min ( dist, dfLine ( uv, vec2(0.388,0.561), vec2(0.806,0.719) ) );
         dist = min ( dist, dfArc  ( uv, vec2(0.500,1.000), 0.000,  pi,   0.5 ) );
         dist = min ( dist, dfArc  ( uv, vec2(0.700,1.000), 5.074, 1.209, 0.3 ) );
         dist = min ( dist, dfArc  ( uv, vec2(0.600,0.000), 1.932, 1.209, 0.6 ) );
         break;
      case 3 :
         dist = min ( dist, dfLine ( uv, vec2(0.000,1.500), vec2(1.000,1.500) ) );
         dist = min ( dist, dfLine ( uv, vec2(1.000,1.500), vec2(0.500,1.000) ) );
         dist = min ( dist, dfArc  ( uv, vec2(0.500,0.500), pi, 4.712, 0.5 ) );
         break;
      case 4 :
         dist = min ( dist, dfLine ( uv, vec2(0.700,1.500), vec2(0.000,0.500) ) );
         dist = min ( dist, dfLine ( uv, vec2(0.000,0.500), vec2(1.000,0.500) ) );
         dist = min ( dist, dfLine ( uv, vec2(0.700,1.200), vec2(0.700,0.000) ) );
         break;
      case 5 :
         dist = min ( dist, dfLine ( uv, vec2(1.000,1.500), vec2(0.300,1.500) ) );
         dist = min ( dist, dfLine ( uv, vec2(0.300,1.500), vec2(0.200,0.900) ) );
         dist = min ( dist, dfArc  ( uv, vec2(0.500,0.500), pi, 5.356, 0.5 ) );
         break;
      case 6 :
         dist = min ( dist, dfLine ( uv, vec2(0.067,0.750), vec2(0.500,1.500) ) );
         dist = min ( dist, dfCirc ( uv, vec2(0.500,0.500), 0.500 ) );
         break;
      case 7 :
         dist = min ( dist, dfLine ( uv, vec2(0.000,1.500), vec2(1.000,1.500) ) );
         dist = min ( dist, dfLine ( uv, vec2(1.000,1.500), vec2(0.500,0.000) ) );
         break;
      case 8 :
         dist = min ( dist, dfCirc ( uv, vec2(0.500,0.400), 0.40 ) );
         dist = min ( dist, dfCirc ( uv, vec2(0.500,1.150), 0.35 ) );
         break;
      case 9 :
         dist = min ( dist, dfLine ( uv, vec2(0.933,0.750), vec2(0.500,0.000) ) );
         dist = min ( dist, dfCirc ( uv, vec2(0.500,1.000), 0.5 ) );
         break;
    }

   return dist;

}

// Distance to a number.

float dfNumber ( vec2 origin, float num, vec2 uv )
{
   uv = uv - origin;

   float dist = 1.0e6;
   float offs = 0.0;

   for ( float i = 5.0; i > -3.0; i-- )
    {
      float d = mod ( num / pow(10.0,i), 10.0 );

      vec2 pos = digitSpacing * vec2(offs,0.0);

      if ( i == 0.0 )
       {
         dist = min ( dist, dfCirc ( uv, vec2(offs+0.9,0.1)*1.1, 0.04 ) );
       }

      if ( num > pow(10.0,i) || i == 0.0 )
       {
         dist = min ( dist, dfDigit ( uv, pos, d ) );
         offs++;
       }

    }

   return dist;

 }

// Length of a number in digits.

float numberLength(float n)
 {
   return floor ( max(log(n)/log(10.0),0.0) + 1.0 ) + 2.0;
 }

void main ( void )
 {
   vec2 aspect = iResolution.xy / iResolution.y;
   vec2 uv = gl_FragCoord.xy / iResolution.y - aspect/2.0;

   float n = iGlobalTime;
   float nsize = numberLength(n);

   vec2 pos = -digitSpacing * vec2(nsize,1.0)/2.0;

   float dist = min ( 1.0e6, dfNumber(pos,n,uv) );

   vec3 color = vec3(1.0,0.2,0.0) * 0.004 / dist;

   #ifdef SHOW_GRID
   float grid = 0.5-max(abs(mod(uv.x*64.0,1.0)-0.5), abs(mod(uv.y*64.0,1.0)-0.5));
   color *= 0.25+vec3(smoothstep(0.0,64.0 / iResolution.y,grid))*0.75;
   #endif

   gl_FragColor = vec4 ( color, 16.0*length(color) );

 }